﻿/// <summary>
/// Demontrsator systemu dzierżaw.
/// </summary>
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Lifetime;
using System;
using BasicServer;
using System.Runtime.Remoting.Channels.Http;
class LeasingDemo : ISponsor
{
    ILease lease;

    // imlementacja logiki dzierżaw
    public void ImplementLease()
    {
        BasicRemotingServer brs = new BasicRemotingServer();

        lease = (ILease)brs.InitializeLifetimeService();
        lease.Register(this, new TimeSpan(0, 0, 3));

        PrintLeaseInfo();

        Console.WriteLine("\nOdpowiedź serwera: {0}",
            brs.GetServerResponse());
    }

    //ISponsor.Renewal - wywołanie w celu odnowienia dziwerżawy
    public TimeSpan Renewal(ILease myLease)
    {
        TimeSpan timeSpan = new TimeSpan(0, 0, 3);

        Console.WriteLine("\nDzierżawa odnowiona.\n");

        PrintLeaseInfo();

        return timeSpan;
    }

    // wypisanie informacji dotyczącej stanu dzierżaw
    void PrintLeaseInfo()
    {
        if (lease != null)
        {
            Console.WriteLine("Informacje dotyczące dzierżaw\n");
            Console.WriteLine("  Wartość CurrentLeaseTime: {0}", lease.CurrentLeaseTime);
            Console.WriteLine("  Wartość InitialLeaseTime: {0}", lease.InitialLeaseTime);
            Console.WriteLine("  Wartość RenewOnCallTime: {0}", lease.RenewOnCallTime);
            Console.WriteLine("Wartość SponsorshipTimeout: {0}", lease.SponsorshipTimeout);
        }
    }

    // metoda główna
    static void Main(string[] args)
    {
        ChannelServices.RegisterChannel(new HttpChannel(), false);

        LeasingDemo leaseDemo = new LeasingDemo();
        leaseDemo.ImplementLease();
    }
}
